% this script was used to generate Figure 4A and B in Mashour et al. 
% Recovery of consciousness and cognition after general anesthesia in humans, 2021
% 
% the following subfunctions will be required:
% pec.m: Gaoxiang Ouyang (2021). Permutation entropy (https://www.mathworks.com/matlabcentral/fileexchange/37289-permutation-entropy), MATLAB Central File Exchange.
% topoplot.m: Delorme A & Makeig S (2004) EEGLAB: an open-source toolbox for analysis of single-trial EEG dynamics, Journal of Neuroscience Methods 134:9-21.
% 
% Duan LI, 2/3/2021
clear
path(path,'.\EEG data')
dataname={'UM_1';'UM_4';'UM_7';'UM_8';'UM_9';'UM_12';'UM_13';'UM_14';'UM_18';'UM_21';...
    'WU_33';'WU_34';'WU_36';'WU_38';'WU_40';'WU_42';'WU_45';'WU_46';'WU_48';'WU_49';...
    'UP_62';'UP_64';'UP_67';'UP_68';'UP_69';'UP_71';'UP_74';'UP_76';'UP_77';'UP_80'};
load EEG_locs_ch21
stage_label={'EC1','LOR','Maintenance','Emergence','EC2', 'EC3', 'EC4', 'EC5', 'EC6', 'EC7'};
Nstage=10;
Nch=21;
fs=250;
epoch=2*60*fs; % segment length
window=10*fs;
N=fix(epoch/window);
band=[0.5,30];
[b,a]=butter(4, [band(1)/(fs/2) band(2)/(fs/2)]);
dim=5;% embedding dimension
tau=4;% time delay
for pp=1:length(dataname)
    load(['anesthesia_',dataname{pp}]);
    for ss=1:Nstage
        x=eeg{ss};
        if ~isempty(x)
            x=filtfilt(b,a,x')';
            for cc=1:Nch
                for nn=1:N
                    temp=x(cc,(nn-1)*window+1:nn*window);
                    PE{ss}(cc,nn)=pec(temp,dim,tau)/log(factorial(dim));
                    clear temp
                end
            end            
        else
            PE{ss}=nan(Nch,N);
        end        
        for cc=1:Nch
            mPE(pp,ss,cc)=nanmedian(PE{ss}(cc,:),2);
        end
    end
end
ave_PE=squeeze(nanmedian(mPE,1));
fig1 = figure('Position',[100 100 1800 300]);set(gcf,'Renderer','zbuffer');
for ss=1:Nstage
    subplot(1,Nstage,ss),topoplot(ave_PE(ss,:),EEG_locs_ch21,'maplimits',[0.65 nanmax(nanmax(ave_PE))]);
    colormap(jet),title([stage_label{ss}]);
end
set(gcf,'color','w');

region{1}=[1,2,20,3,4,17];%FP+F
region{2}=[7,8,18,9,10,19];%P+O
for qq=1:size(region,2)
    PE_region{qq}=squeeze(nanmean(mPE(:,:,region{qq}),3));
end
fig2 = figure('Position',[100 100 400 600]);set(gcf,'Renderer','zbuffer','color','w');
subplot(211),boxplot(PE_region{1}),xlim([0,Nstage+1]),ylim([0.67,1.05]),
ylabel('PE'),title('Frontal'),
subplot(212),boxplot(PE_region{2}),xlim([0,Nstage+1]),ylim([0.67,1.05]),
ylabel('PE'),title('Posterior')